/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class DemonFormPower
extends AbstractPower {
    public static final String POWER_ID = "Demon Form";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Demon Form");
    public static final String NAME = DemonFormPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = DemonFormPower.powerStrings.DESCRIPTIONS;

    public DemonFormPower(AbstractCreature owner, int strengthAmount) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = strengthAmount;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/drawCardRed.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
    }

    @Override
    public void atStartOfTurnPostDraw() {
        this.flash();
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this.owner, this.owner, new StrengthPower(this.owner, this.amount), this.amount));
    }
}

